/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantAttackAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class FightOrFlightEffect
extends OneShotEffect {
    FightOrFlightEffect() {
        super(Outcome.Detriment);
        this.staticText = "separate all creatures that player controls into two piles. Only creatures in the pile of their choice can attack this turn";
    }

    private FightOrFlightEffect(FightOrFlightEffect effect) {
        super((OneShotEffect)effect);
    }

    public FightOrFlightEffect copy() {
        return new FightOrFlightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(game.getCombat().getAttackingPlayerId());
        if (player == null || targetPlayer == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures to put in the first pile");
        filter.add((Predicate)new ControllerIdPredicate(targetPlayer.getId()));
        TargetPermanent creatures = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)filter, true);
        ArrayList<Permanent> pile1 = new ArrayList<Permanent>();
        if (player.choose(Outcome.Neutral, (Target)creatures, source, game)) {
            List targets = creatures.getTargets();
            for (UUID targetId : targets) {
                Permanent p = game.getPermanent(targetId);
                if (p == null) continue;
                pile1.add(p);
            }
        }
        ArrayList<Permanent> pile2 = new ArrayList<Permanent>();
        for (Permanent p : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, targetPlayer.getId(), game)) {
            if (pile1.contains(p)) continue;
            pile2.add(p);
        }
        boolean choice = targetPlayer.choosePile(this.outcome, "Choose which pile can attack this turn.", pile1, pile2, game);
        ArrayList<Permanent> canAttack = choice ? pile1 : pile2;
        FilterCreaturePermanent filterRestriction = new FilterCreaturePermanent();
        filterRestriction.add(Predicates.not((Predicate)new PermanentReferenceInCollectionPredicate(canAttack, game)));
        game.addEffect((ContinuousEffect)new CantAttackAllEffect(Duration.EndOfTurn, filterRestriction), source);
        game.informPlayers("Creatures that can attack this turn: " + canAttack.stream().map(MageObject::getLogName).collect(Collectors.joining(", ")));
        return true;
    }
}

