/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FighterClassRequirementEffect
extends RequirementEffect {
    private final MageObjectReference mor;

    public FighterClassRequirementEffect(MageObjectReference mor) {
        super(Duration.EndOfCombat);
        this.mor = mor;
    }

    private FighterClassRequirementEffect(FighterClassRequirementEffect effect) {
        super((RequirementEffect)effect);
        this.mor = effect.mor;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent attacker = this.mor.getPermanent(game);
        if (attacker == null) {
            this.discard();
            return false;
        }
        return permanent != null && permanent.getId().equals(this.getTargetPointer().getFirst(game, source)) && permanent.canBlock(source.getSourceId(), game);
    }

    public boolean mustAttack(Game game) {
        return false;
    }

    public boolean mustBlock(Game game) {
        return true;
    }

    public UUID mustBlockAttacker(Ability source, Game game) {
        return this.mor.getSourceId();
    }

    public FighterClassRequirementEffect copy() {
        return new FighterClassRequirementEffect(this);
    }
}

