/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class FinalPartingEffect
extends OneShotEffect {
    protected static final FilterCard filter = new FilterCard("card to put into your hand");

    public FinalPartingEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "Search your library for two cards. Put one into your hand and the other into your graveyard. Then shuffle";
    }

    private FinalPartingEffect(FinalPartingEffect effect) {
        super((OneShotEffect)effect);
    }

    public FinalPartingEffect copy() {
        return new FinalPartingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetCardInLibrary target = new TargetCardInLibrary(2, 2, new FilterCard());
            if (controller.searchLibrary(target, source, game)) {
                if (!target.getTargets().isEmpty()) {
                    Card card;
                    CardsImpl searched = new CardsImpl();
                    for (UUID cardId : target.getTargets()) {
                        Card card2 = controller.getLibrary().getCard(cardId, game);
                        searched.add(card2);
                    }
                    if (target.getTargets().size() == 2) {
                        TargetCard target2 = new TargetCard(Zone.LIBRARY, filter);
                        controller.choose(Outcome.Benefit, (Cards)searched, target2, source, game);
                        card = searched.get(target2.getFirstTarget(), game);
                        controller.moveCards(card, Zone.HAND, source, game);
                        searched.remove(card);
                        Set cards = searched.getCards(game);
                        card = cards.isEmpty() ? null : (Card)cards.iterator().next();
                        controller.moveCards(card, Zone.GRAVEYARD, source, game);
                    } else if (target.getTargets().size() == 1) {
                        Set cards = searched.getCards(game);
                        card = cards.isEmpty() ? null : (Card)cards.iterator().next();
                        controller.moveCards(card, Zone.HAND, source, game);
                    }
                }
                controller.shuffleLibrary(source, game);
                return true;
            }
            controller.shuffleLibrary(source, game);
        }
        return false;
    }
}

