/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FinalShowdownEffect
extends OneShotEffect {
    FinalShowdownEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a creature you control. It gains indestructible until end of turn";
    }

    private FinalShowdownEffect(FinalShowdownEffect effect) {
        super((OneShotEffect)effect);
    }

    public FinalShowdownEffect copy() {
        return new FinalShowdownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source, game, 1)) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        game.addEffect(new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game)), source);
        return true;
    }
}

