/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.f.FireGiantsFuryDelayedEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FireGiantsFuryDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final MageObjectReference mor;

    public FireGiantsFuryDelayedTriggeredAbility(MageObjectReference mor) {
        super((Effect)new FireGiantsFuryDelayedEffect(), Duration.EndOfTurn, false, false);
        this.mor = mor;
    }

    private FireGiantsFuryDelayedTriggeredAbility(FireGiantsFuryDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.mor = ability.mor;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.mor.refersTo(event.getSourceId(), game) && ((DamagedEvent)event).isCombatDamage()) {
            for (Effect effect : this.getAllEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
                effect.setValue("damage", (Object)event.getAmount());
            }
            return true;
        }
        return false;
    }

    public FireGiantsFuryDelayedTriggeredAbility copy() {
        return new FireGiantsFuryDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever it deals combat damage to a player this turn, exile that many cards from the top of your library. Until the end of your next turn, you may play those cards";
    }
}

