/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.cards.f.FireLordSozinTarget;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class FireLordSozinEffect
extends OneShotEffect {
    FireLordSozinEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}. When you do, put any number of target creature cards with total mana value X or less from that player's graveyard onto the battlefield under your control";
    }

    private FireLordSozinEffect(FireLordSozinEffect effect) {
        super((OneShotEffect)effect);
    }

    public FireLordSozinEffect copy() {
        return new FireLordSozinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller == null || !controller.chooseUse(Outcome.BoostCreature, "Pay {X}?", source, game)) {
            return false;
        }
        int xValue = controller.announceX(0, Integer.MAX_VALUE, "Announce the value for {X}", game, source, true);
        ManaCostsImpl cost = new ManaCostsImpl("{X}");
        cost.add((Object)new GenericManaCost(xValue));
        if (!cost.pay(source, game, source, source.getControllerId(), false, null)) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect(), false);
        ability.addTarget((Target)new FireLordSozinTarget((UUID)this.getValue("damagedPlayer"), xValue));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

