/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.target.common.TargetCardInGraveyard;
import mage.util.CardUtil;

class FireLordSozinTarget
extends TargetCardInGraveyard {
    private final int xValue;

    private static final FilterCard makeFilter(UUID ownerId, int xValue) {
        FilterCreatureCard filter = new FilterCreatureCard("creature cards with total mana value " + xValue + " or less from that player's graveyard");
        filter.add((Predicate)new OwnerIdPredicate(ownerId));
        return filter;
    }

    FireLordSozinTarget(UUID ownerId, int xValue) {
        super(0, Integer.MAX_VALUE, FireLordSozinTarget.makeFilter(ownerId, xValue), false);
        this.xValue = xValue;
    }

    private FireLordSozinTarget(FireLordSozinTarget target) {
        super((TargetCardInGraveyard)target);
        this.xValue = target.xValue;
    }

    public FireLordSozinTarget copy() {
        return new FireLordSozinTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        return super.canTarget(playerId, id, source, game) && CardUtil.checkCanTargetTotalValueLimit((Collection)this.getTargets(), (UUID)id, MageObject::getManaValue, (int)this.xValue, (Game)game);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        return CardUtil.checkPossibleTargetsTotalValueLimit((Collection)this.getTargets(), (Set)super.possibleTargets(sourceControllerId, source, game), MageObject::getManaValue, (int)this.xValue, (Game)game);
    }

    public String getMessage(Game game) {
        int selectedValue = this.getTargets().stream().map(arg_0 -> ((Game)game).getObject(arg_0)).filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
        return super.getMessage(game) + " (selected total mana value " + selectedValue + ")";
    }
}

