/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class FireballEffect
extends OneShotEffect {
    FireballEffect() {
        super(Outcome.Damage);
        this.staticText = "this spell costs {1} more to cast for each target beyond the first.<br> {this} deals X damage divided evenly, rounded down, among any number of targets";
    }

    private FireballEffect(FireballEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int damagePer;
        int numTargets = this.getTargetPointer().getTargets(game, source).size();
        int damage = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (numTargets > 0 && (damagePer = damage / numTargets) > 0) {
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent != null) {
                    permanent.damage(damagePer, source.getSourceId(), source, game, false, true);
                    continue;
                }
                Player player = game.getPlayer(targetId);
                if (player == null) continue;
                player.damage(damagePer, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }

    public FireballEffect copy() {
        return new FireballEffect(this);
    }
}

