/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ElementalCatToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class FirecatBlitzEffect
extends OneShotEffect {
    FirecatBlitzEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create X 1/1 red Elemental Cat creature tokens with haste. Exile them at the beginning of the next end step";
    }

    private FirecatBlitzEffect(FirecatBlitzEffect effect) {
        super((OneShotEffect)effect);
    }

    public FirecatBlitzEffect copy() {
        return new FirecatBlitzEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            for (Cost cost : source.getCosts()) {
                if (!(cost instanceof SacrificeTargetCost)) continue;
                xValue = ((SacrificeTargetCost)cost).getPermanents().size();
            }
            CreateTokenEffect effect = new CreateTokenEffect((Token)new ElementalCatToken(), xValue);
            effect.apply(game, source);
            for (UUID tokenId : effect.getLastAddedTokenIds()) {
                Permanent tokenPermanent = game.getPermanent(tokenId);
                if (tokenPermanent == null) continue;
                ExileTargetEffect exileEffect = new ExileTargetEffect(null, "", Zone.BATTLEFIELD);
                exileEffect.setTargetPointer((TargetPointer)new FixedTarget(tokenPermanent, game));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect), source);
            }
            return true;
        }
        return false;
    }
}

