/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashMap;
import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class FiremindsForesightSearchEffect
extends OneShotEffect {
    private static final Map<Integer, FilterCard> filterMap = new HashMap<Integer, FilterCard>();

    FiremindsForesightSearchEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Search your library for an instant card with mana value 3, reveal it, and put it into your hand. Then repeat this process for instant cards with mana values 2 and 1. Then shuffle";
    }

    private FiremindsForesightSearchEffect(FiremindsForesightSearchEffect effect) {
        super((OneShotEffect)effect);
    }

    public FiremindsForesightSearchEffect copy() {
        return new FiremindsForesightSearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cardToReveal = new CardsImpl();
        for (int cmc = 3; cmc > 0; --cmc) {
            TargetCardInLibrary target = new TargetCardInLibrary(filterMap.get(cmc));
            player.searchLibrary(target, source, game);
            Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
            if (card == null) continue;
            cardToReveal.clear();
            cardToReveal.add(card);
            player.revealCards(source, (Cards)cardToReveal, game);
            player.moveCards((Cards)cardToReveal, Zone.HAND, source, game);
        }
        player.shuffleLibrary(source, game);
        return true;
    }

    static {
        for (int cmc = 3; cmc > 0; --cmc) {
            FilterCard filter = new FilterCard("instant card with mana value " + cmc);
            filter.add((Predicate)CardType.INSTANT.getPredicate());
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, cmc));
            filterMap.put(cmc, filter);
        }
    }
}

