/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.CastSpellLastTurnWatcher;

class FiresOfInventionCastEffect
extends ContinuousRuleModifyingEffectImpl {
    FiresOfInventionCastEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "you can cast spells only during your turn and you can cast no more than two spells each turn";
    }

    private FiresOfInventionCastEffect(FiresOfInventionCastEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public FiresOfInventionCastEffect copy() {
        return new FiresOfInventionCastEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!event.getPlayerId().equals(source.getControllerId())) {
            return false;
        }
        CastSpellLastTurnWatcher watcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
        if (watcher == null) {
            return false;
        }
        return watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(source.getControllerId()) > 1 || !game.getActivePlayerId().equals(source.getControllerId());
    }
}

