/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FirstDayOfClassTriggeredAbility
extends DelayedTriggeredAbility {
    public FirstDayOfClassTriggeredAbility() {
        super((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()), Duration.EndOfTurn, false);
        this.addEffect((Effect)new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn));
    }

    private FirstDayOfClassTriggeredAbility(FirstDayOfClassTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public FirstDayOfClassTriggeredAbility copy() {
        return new FirstDayOfClassTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you control enters this turn, put a +1/+1 counter on it and it gains haste until end of turn";
    }
}

