/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.f.TapAttachmentCost;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FishingPoleEffect
extends ContinuousEffectImpl {
    FishingPoleEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "equipped creature has \"{1}, {T}, Tap {this}: Put a bait counter on {this}.\"";
    }

    private FishingPoleEffect(FishingPoleEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public FishingPoleEffect copy() {
        return new FishingPoleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent fishingPole = source.getSourcePermanentIfItStillExists(game);
        if (fishingPole == null) {
            return false;
        }
        Permanent creature = game.getPermanent(fishingPole.getAttachedTo());
        if (creature == null) {
            return false;
        }
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new AddCountersTargetEffect(CounterType.BAIT.createInstance()).setTargetPointer((TargetPointer)new FixedTarget(fishingPole, game)).setText("put a bait counter on " + fishingPole.getName()), (Cost)new GenericManaCost(1));
        ability.addCost((Cost)new TapSourceCost());
        ability.addCost((Cost)new TapAttachmentCost().setMageObjectReference(source, game));
        creature.addAbility((Ability)ability, source.getSourceId(), game);
        return true;
    }
}

