/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ClashEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FistfulOfForceEffect
extends OneShotEffect {
    FistfulOfForceEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Target creature gets +2/+2 until end of turn. Clash with an opponent. If you win, that creature gets an additional +2/+2 and gains trample until end of turn";
    }

    private FistfulOfForceEffect(FistfulOfForceEffect effect) {
        super((OneShotEffect)effect);
    }

    public FistfulOfForceEffect copy() {
        return new FistfulOfForceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && creature != null) {
            BoostTargetEffect effect = new BoostTargetEffect(2, 2, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            if (new ClashEffect().apply(game, source)) {
                game.addEffect(effect.copy(), source);
                effect = new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
                game.addEffect(effect.copy(), source);
            }
            return true;
        }
        return false;
    }
}

