/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.condition.common.ControlledModifiedCreatureAsSpellCastCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class FlameDischargeEffect
extends OneShotEffect {
    FlameDischargeEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to target creature or planeswalker. If you controlled a modified creature as you cast this spell, it deals X plus 2 damage instead";
    }

    private FlameDischargeEffect(FlameDischargeEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlameDischargeEffect copy() {
        return new FlameDischargeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int damageAmount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (ControlledModifiedCreatureAsSpellCastCondition.instance.apply(game, source)) {
            damageAmount += 2;
        }
        permanent.damage(damageAmount, source, game);
        return true;
    }
}

