/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CountersSourceCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.f.FlamesOfRemembranceMayPlayExiledEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class FlamesOfRemembranceExileEffect
extends OneShotEffect {
    private CountersSourceCount amount;

    public FlamesOfRemembranceExileEffect(CountersSourceCount amount) {
        super(Outcome.Benefit);
        this.amount = amount;
        this.staticText = "Exile top X cards of your library, where X is the number of lore counters on {this}. Until end of turn you play cards exile this way";
    }

    private FlamesOfRemembranceExileEffect(FlamesOfRemembranceExileEffect effect) {
        super((OneShotEffect)effect);
        this.amount = effect.amount;
    }

    public FlamesOfRemembranceExileEffect copy() {
        return new FlamesOfRemembranceExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, this.amount.calculate(game, source, (Effect)this)));
            if (!cards.isEmpty()) {
                controller.moveCardsToExile(cards.getCards(game), source, game, true, source.getSourceId(), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, (String)""));
                FlamesOfRemembranceMayPlayExiledEffect effect = new FlamesOfRemembranceMayPlayExiledEffect();
                effect.setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

