/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class FlamesOfTheBloodHandReplacementEffect
extends ReplacementEffectImpl {
    FlamesOfTheBloodHandReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "If that player or that planeswalker's controller would gain life this turn, that player gains no life instead";
    }

    private FlamesOfTheBloodHandReplacementEffect(FlamesOfTheBloodHandReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FlamesOfTheBloodHandReplacementEffect copy() {
        return new FlamesOfTheBloodHandReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.GAIN_LIFE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(this.getTargetPointer().getFirst(game, source));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }
}

