/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FlareOfFaithEffect
extends OneShotEffect {
    FlareOfFaithEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature gets +2/+2 until end of turn. If it's a Human, instead it gets +3/+3 and gains indestructible until end of turn";
    }

    private FlareOfFaithEffect(FlareOfFaithEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlareOfFaithEffect copy() {
        return new FlareOfFaithEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (permanent.hasSubtype(SubType.HUMAN, game)) {
            game.addEffect((ContinuousEffect)new BoostTargetEffect(3, 3), source);
            game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn), source);
        } else {
            game.addEffect((ContinuousEffect)new BoostTargetEffect(2, 2), source);
        }
        return true;
    }
}

