/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FlayEssenceEffect
extends OneShotEffect {
    FlayEssenceEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target creature or planeswalker. You gain life equal to the number of counters on it";
    }

    private FlayEssenceEffect(FlayEssenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlayEssenceEffect copy() {
        return new FlayEssenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && permanent != null) {
            int life = 0;
            for (Counter counter : permanent.getCounters(game).values()) {
                life += counter.getCount();
            }
            controller.moveCards((Card)permanent, Zone.EXILED, source, game);
            controller.gainLife(life, game, source);
            return true;
        }
        return false;
    }
}

