/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.HorrorXXBlackToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class FleshCarverEffect
extends OneShotEffect {
    FleshCarverEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "create an X/X black Horror creature token, where X is {this}'s power";
    }

    private FleshCarverEffect(FleshCarverEffect ability) {
        super((OneShotEffect)ability);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int xValue = (Integer)this.getValue("power");
            return new CreateTokenEffect((Token)new HorrorXXBlackToken(xValue)).apply(game, source);
        }
        return false;
    }

    public FleshCarverEffect copy() {
        return new FleshCarverEffect(this);
    }
}

