/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class FleshwritherEffect
extends OneShotEffect {
    FleshwritherEffect() {
        super(Outcome.Benefit);
    }

    private FleshwritherEffect(FleshwritherEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = source.getSourcePermanentOrLKI(game);
        if (sourcePermanent == null || controller == null) {
            return false;
        }
        FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value " + sourcePermanent.getManaValue());
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, sourcePermanent.getManaValue()));
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)filter);
        controller.searchLibrary(target, source, game);
        controller.moveCards(controller.getLibrary().getCard(target.getFirstTarget(), game), Zone.BATTLEFIELD, source, game);
        controller.shuffleLibrary(source, game);
        return true;
    }

    public FleshwritherEffect copy() {
        return new FleshwritherEffect(this);
    }
}

