/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.util.CardUtil;

class FlickerformReturnEffect
extends OneShotEffect {
    private static final FilterCard filterAura = new FilterCard();
    private final UUID enchantedCardId;
    private final UUID exileZoneId;

    public FlickerformReturnEffect(UUID enchantedCardId, UUID exileZoneId) {
        super(Outcome.Benefit);
        this.enchantedCardId = enchantedCardId;
        this.exileZoneId = exileZoneId;
        this.staticText = "return that card to the battlefield under its owner's control. If you do, return the other cards exiled this way to the battlefield under their owners' control attached to that creature";
    }

    private FlickerformReturnEffect(FlickerformReturnEffect effect) {
        super((OneShotEffect)effect);
        this.enchantedCardId = effect.enchantedCardId;
        this.exileZoneId = effect.exileZoneId;
    }

    public FlickerformReturnEffect copy() {
        return new FlickerformReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(this.exileZoneId);
        Card enchantedCard = exileZone.get(this.enchantedCardId, game);
        if (enchantedCard == null) {
            return false;
        }
        Player owner = game.getPlayer(enchantedCard.getOwnerId());
        if (owner == null) {
            return false;
        }
        owner.moveCards(enchantedCard, Zone.BATTLEFIELD, source, game);
        Permanent newPermanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)enchantedCard, (Game)game);
        if (newPermanent != null) {
            HashSet<Card> toBattlefieldAttached = new HashSet<Card>();
            for (Card enchantment : exileZone.getCards(game)) {
                if (filterAura.match(enchantment, game)) {
                    boolean canTarget = false;
                    for (Target target : enchantment.getSpellAbility().getTargets()) {
                        Filter filter = target.getFilter();
                        if (!filter.match((Object)newPermanent, game)) continue;
                        canTarget = true;
                        break;
                    }
                    if (!canTarget) continue;
                    game.getState().setValue("attachTo:" + enchantment.getId(), (Object)newPermanent);
                }
                toBattlefieldAttached.add(enchantment);
            }
            if (!toBattlefieldAttached.isEmpty()) {
                controller.moveCards(toBattlefieldAttached, Zone.BATTLEFIELD, source, game);
                for (Card card : toBattlefieldAttached) {
                    if (game.getState().getZone(card.getId()) != Zone.BATTLEFIELD) continue;
                    newPermanent.addAttachment(card.getId(), source, game);
                }
            }
        }
        return true;
    }

    static {
        filterAura.add((Predicate)CardType.ENCHANTMENT.getPredicate());
        filterAura.add((Predicate)SubType.AURA.getPredicate());
    }
}

