/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Optional;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ElfWarriorToken;
import mage.game.permanent.token.Token;

class FlourishingDefensesTriggeredAbility
extends TriggeredAbilityImpl {
    FlourishingDefensesTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new ElfWarriorToken()), true);
    }

    private FlourishingDefensesTriggeredAbility(FlourishingDefensesTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FlourishingDefensesTriggeredAbility copy() {
        return new FlourishingDefensesTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getData().equals(CounterType.M1M1.getName())) {
            Permanent permanent = Optional.ofNullable(game.getPermanentOrLKIBattlefield(event.getTargetId())).orElse(game.getPermanentEntering(event.getTargetId()));
            return permanent != null && permanent.isCreature(game);
        }
        return false;
    }

    public String getRule() {
        return "Whenever a -1/-1 counter is put on a creature, you may create a 1/1 green Elf Warrior creature token.";
    }
}

