/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.CantBlockSourceEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class FlummoxedCyclopsTriggeredAbility
extends TriggeredAbilityImpl {
    FlummoxedCyclopsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CantBlockSourceEffect(Duration.EndOfCombat));
    }

    private FlummoxedCyclopsTriggeredAbility(FlummoxedCyclopsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FlummoxedCyclopsTriggeredAbility copy() {
        return new FlummoxedCyclopsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getOpponents(this.getControllerId()).contains(game.getCombat().getAttackingPlayerId())) {
            return false;
        }
        return game.getCombat().getAttackers().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).count() > 1L;
    }

    public String getRule() {
        return "Whenever two or more creatures your opponents control attack, {this} can't block this combat.";
    }
}

