/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.dynamicvalue.common.CommanderCastCountValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class FontOfMagicEffect
extends CostModificationEffectImpl {
    FontOfMagicEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "instant and sorcery spells you cast cost {1} less to cast for each time you've cast a commander from the command zone this game";
    }

    private FontOfMagicEffect(FontOfMagicEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)Math.max(0, CommanderCastCountValue.instance.calculate(game, source, (Effect)this)));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId()) && ((SpellAbility)abilityToModify).getCharacteristics(game).isInstantOrSorcery(game) && game.getCard(abilityToModify.getSourceId()) != null;
    }

    public FontOfMagicEffect copy() {
        return new FontOfMagicEffect(this);
    }
}

