/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ForceDrainEffect
extends OneShotEffect {
    ForceDrainEffect() {
        super(Outcome.Damage);
        this.staticText = "ForceDrain deals 2 damage to any target. If player was dealt damage this way, you gain 2 life";
    }

    private ForceDrainEffect(ForceDrainEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForceDrainEffect copy() {
        return new ForceDrainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null) {
                permanent.damage(2, source.getId(), source, game, false, true);
                return true;
            }
            Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (player != null) {
                if (player.damage(2, source.getId(), source, game) > 0) {
                    controller.gainLife(2, game, source);
                }
                return true;
            }
        }
        return false;
    }
}

