/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class ForesightEffect
extends SearchEffect {
    ForesightEffect() {
        super(new TargetCardInLibrary(3, StaticFilters.FILTER_CARD), Outcome.Benefit);
        this.staticText = "Search your library for three cards, exile them, then shuffle";
    }

    private ForesightEffect(ForesightEffect effect) {
        super((SearchEffect)effect);
    }

    public ForesightEffect copy() {
        return new ForesightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.searchLibrary(this.target, source, game);
        CardsImpl cards = new CardsImpl();
        for (UUID targetId : this.target.getTargets()) {
            Card card = player.getLibrary().getCard(targetId, game);
            if (card == null) continue;
            cards.add(card);
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

