/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class ForethoughtAmuletEffect
extends ReplacementEffectImpl {
    ForethoughtAmuletEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If an instant or sorcery source would deal 3 or more damage to you, it deals 2 damage to you instead";
    }

    private ForethoughtAmuletEffect(ForethoughtAmuletEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ForethoughtAmuletEffect copy() {
        return new ForethoughtAmuletEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getAmount() >= 3) {
            MageObject object = game.getObject(event.getSourceId());
            return object != null && object.isInstantOrSorcery(game);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getControllerId())) {
            event.setAmount(2);
        }
        return false;
    }
}

