/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.keyword.EquipAbility;
import mage.cards.f.ForgeAnewWatcher;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ForgeAnewCostEffect
extends CostModificationEffectImpl {
    ForgeAnewCostEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.SET_COST);
        this.staticText = "you may pay {0} rather than pay the equip cost of the first equip ability you activate during each of your turns.";
    }

    private ForgeAnewCostEffect(ForgeAnewCostEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof EquipAbility && source.isControlledBy(abilityToModify.getControllerId()) && game.getActivePlayerId().equals(source.getControllerId()) && !ForgeAnewWatcher.checkPlayer(abilityToModify.getControllerId(), game);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        boolean applyReduce = false;
        if (game.inCheckPlayableState()) {
            applyReduce = true;
        } else {
            Player controller = game.getPlayer(abilityToModify.getControllerId());
            if (controller != null && controller.chooseUse(Outcome.PlayForFree, String.format("Pay {0} to equip instead %s?", abilityToModify.getManaCostsToPay().getText()), source, game)) {
                applyReduce = true;
            }
        }
        if (applyReduce) {
            abilityToModify.getCosts().clear();
            abilityToModify.getManaCostsToPay().clear();
            return true;
        }
        return false;
    }

    public ForgeAnewCostEffect copy() {
        return new ForgeAnewCostEffect(this);
    }
}

