/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.f.ForgersFoundryExileEffect;
import mage.constants.ComparisonType;
import mage.constants.Zone;
import mage.filter.common.FilterInstantOrSorcerySpell;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class ForgersFoundryTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterInstantOrSorcerySpell filter = new FilterInstantOrSorcerySpell("an instant or sorcery spell with mana value 3 or less");
    String abilityOriginalId;

    public ForgersFoundryTriggeredAbility(UUID abilityOriginalId) {
        super(Zone.ALL, null, false);
        this.abilityOriginalId = abilityOriginalId.toString();
        this.setTriggerPhrase("When that mana is used to cast an instant or sorcery spell with mana value 3 or less, ");
    }

    private ForgersFoundryTriggeredAbility(ForgersFoundryTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
        this.abilityOriginalId = ability.abilityOriginalId;
    }

    public ForgersFoundryTriggeredAbility copy() {
        return new ForgersFoundryTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MANA_PAID;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        if (event.getData().equals(this.abilityOriginalId) && (spell = game.getStack().getSpell(event.getTargetId())) != null && filter.match((StackObject)spell, this.getControllerId(), (Ability)this, game)) {
            this.getEffects().clear();
            this.addEffect((Effect)new ForgersFoundryExileEffect(spell, game));
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, 3));
    }
}

