/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.CantBeBlockedByCreaturesSourceEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.f.FormationBreakerPredicate;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CounterAnyPredicate;

public final class FormationBreaker
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();
    private static final FilterPermanent filter2 = new FilterControlledCreaturePermanent();
    private static final Condition condition;
    private static final Hint hint;

    public FormationBreaker(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{G}");
        this.subtype.add((Object)SubType.BEAST);
        this.power = new MageInt(2);
        this.toughness = new MageInt(1);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new CantBeBlockedByCreaturesSourceEffect(filter, Duration.WhileOnBattlefield).setText("creatures with power less than this creature's power can't block it")));
        this.addAbility(new SimpleStaticAbility((Effect)new ConditionalContinuousEffect((ContinuousEffect)new BoostSourceEffect(1, 2, Duration.WhileOnBattlefield), condition, "as long as you control a creature with a counter on it, this creature gets +1/+2")).addHint(hint));
    }

    private FormationBreaker(FormationBreaker card) {
        super((CardImpl)card);
    }

    public FormationBreaker copy() {
        return new FormationBreaker(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)FormationBreakerPredicate.instance);
        filter2.add((Predicate)CounterAnyPredicate.instance);
        condition = new PermanentsOnTheBattlefieldCondition(filter2);
        hint = new ConditionHint(condition, "You control a creature with a counter on it");
    }
}

