/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.ArrayList;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileThenReturnTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.SaddledSourceThisTurnPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class FortuneLoyalSteedEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature that saddled it this turn");

    FortuneLoyalSteedEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it and up to one creature that saddled it this turn, then return those cards to the battlefield under their owner's control";
    }

    private FortuneLoyalSteedEffect(FortuneLoyalSteedEffect effect) {
        super((OneShotEffect)effect);
    }

    public FortuneLoyalSteedEffect copy() {
        return new FortuneLoyalSteedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ArrayList<Permanent> permanents = new ArrayList<Permanent>();
        permanents.add(source.getSourcePermanentIfItStillExists(game));
        TargetPermanent target = new TargetPermanent(0, 1, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        permanents.add(game.getPermanent(target.getFirstTarget()));
        permanents.removeIf(Objects::isNull);
        return !permanents.isEmpty() && new ExileThenReturnTargetEffect(false, false).setTargetPointer((TargetPointer)new FixedTargets(permanents, game)).apply(game, source);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)SaddledSourceThisTurnPredicate.instance);
    }
}

