/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FortuneThiefReplacementEffect
extends ReplacementEffectImpl {
    FortuneThiefReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Damage that would reduce your life total to less than 1 reduces it to 1 instead";
    }

    private FortuneThiefReplacementEffect(FortuneThiefReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FortuneThiefReplacementEffect copy() {
        return new FortuneThiefReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_CAUSES_LIFE_LOSS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && (controller = game.getPlayer(source.getControllerId())) != null && controller.getLife() > 0 && controller.getLife() - event.getAmount() < 1 && event.getPlayerId().equals(controller.getId())) {
            event.setAmount(controller.getLife() - 1);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return false;
    }
}

