/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class FossilFindEffect
extends OneShotEffect {
    FossilFindEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return a card at random from your graveyard to your hand, then reorder your graveyard as you choose";
    }

    private FossilFindEffect(FossilFindEffect effect) {
        super((OneShotEffect)effect);
    }

    public FossilFindEffect copy() {
        return new FossilFindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && !controller.getGraveyard().isEmpty()) {
            Card card = controller.getGraveyard().getRandom(game);
            if (card != null) {
                controller.moveCards(card, Zone.HAND, source, game);
                return true;
            }
            controller.moveCards((Cards)controller.getGraveyard(), Zone.GRAVEYARD, source, game);
        }
        return false;
    }
}

