/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.f.FranticScapegoatSuspectEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeBatchEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class FranticScapegoatTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<ZoneChangeEvent> {
    FranticScapegoatTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new FranticScapegoatSuspectEffect(), true);
    }

    private FranticScapegoatTriggeredAbility(FranticScapegoatTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_BATCH;
    }

    public boolean checkInterveningIfClause(Game game) {
        Permanent source = this.getSourcePermanentIfItStillExists(game);
        return source != null && source.isSuspected();
    }

    public boolean checkEvent(ZoneChangeEvent event, Game game) {
        if (event.getToZone() != Zone.BATTLEFIELD) {
            return false;
        }
        Permanent permanent = event.getTarget();
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Set enteringCreatures = this.getFilteredEvents((BatchEvent)((ZoneChangeBatchEvent)event), game).stream().map(ZoneChangeEvent::getTarget).filter(Objects::nonNull).map(p -> new MageObjectReference((MageObject)p, game)).collect(Collectors.toSet());
        if (!enteringCreatures.isEmpty()) {
            this.getEffects().setValue("franticScapegoatEnteringCreatures", enteringCreatures);
            return true;
        }
        return false;
    }

    public FranticScapegoatTriggeredAbility copy() {
        return new FranticScapegoatTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more other creatures enter the battlefield under your control, if {this} is suspected, you may suspect one of the other creatures. If you do, {this} is no longer suspected.";
    }
}

