/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class FreeForAllExileAllEffect
extends OneShotEffect {
    FreeForAllExileAllEffect() {
        super(Outcome.Exile);
        this.staticText = "exile all creatures face down";
    }

    private FreeForAllExileAllEffect(FreeForAllExileAllEffect effect) {
        super((OneShotEffect)effect);
    }

    public FreeForAllExileAllEffect copy() {
        return new FreeForAllExileAllEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game).stream().forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.moveCardsToExile(cards.getCards(game), source, game, false, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        cards.getCards(game).stream().filter(card -> game.getState().getZone(card.getId()) == Zone.EXILED).forEach(card -> card.setFaceDown(true, game));
        return true;
    }
}

