/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class FreeForAllReturnFromExileEffect
extends OneShotEffect {
    FreeForAllReturnFromExileEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "that player chooses a card exiled with {this} at random and puts it onto the battlefield";
    }

    private FreeForAllReturnFromExileEffect(FreeForAllReturnFromExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public FreeForAllReturnFromExileEffect copy() {
        return new FreeForAllReturnFromExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        ExileZone exZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (player == null || exZone == null || exZone.isEmpty()) {
            return false;
        }
        CardsImpl exiledCards = new CardsImpl(exZone.getCards(game));
        return player.moveCards(exiledCards.getRandom(game), Zone.BATTLEFIELD, source, game);
    }
}

