/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.f.FreeRangeChickenWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FreeRangeChickenEffect
extends OneShotEffect {
    FreeRangeChickenEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Roll two six-sided dice. If both results are the same, {this} gets +X/+X until end of turn, where X is that result. If the total of those results is equal to any other total you have rolled this turn for {this}, sacrifice it";
    }

    private FreeRangeChickenEffect(FreeRangeChickenEffect effect) {
        super((OneShotEffect)effect);
    }

    public FreeRangeChickenEffect copy() {
        return new FreeRangeChickenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            FreeRangeChickenWatcher watcher;
            int secondRoll;
            List results = controller.rollDice(this.outcome, source, game, 6, 2, 0);
            int firstRoll = (Integer)results.get(0);
            if (firstRoll == (secondRoll = ((Integer)results.get(1)).intValue())) {
                game.addEffect((ContinuousEffect)new BoostSourceEffect(firstRoll, firstRoll, Duration.EndOfTurn), source);
            }
            if ((watcher = (FreeRangeChickenWatcher)game.getState().getWatcher(FreeRangeChickenWatcher.class)) != null) {
                int totalRoll = firstRoll + secondRoll;
                Permanent sourcePermanent = game.getPermanent(source.getSourceId());
                if (sourcePermanent != null) {
                    if (watcher.rolledThisTurn(sourcePermanent.getId(), totalRoll)) {
                        sourcePermanent.sacrifice(source, game);
                    } else {
                        watcher.addRoll(sourcePermanent.getId(), totalRoll);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

