/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.keyword.BoastAbility;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;

class FrenziedRaiderTriggeredAbility
extends TriggeredAbilityImpl {
    FrenziedRaiderTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()), false);
    }

    private FrenziedRaiderTriggeredAbility(FrenziedRaiderTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FrenziedRaiderTriggeredAbility copy() {
        return new FrenziedRaiderTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(event.getTargetId());
        return stackAbility != null && stackAbility.getStackAbility() instanceof BoastAbility;
    }

    public String getRule() {
        return "Whenever you activate a boast ability, put a +1/+1 counter on {this}.";
    }
}

