/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FriendlyFireEffect
extends OneShotEffect {
    FriendlyFireEffect() {
        super(Outcome.Discard);
        this.staticText = "Target creature's controller reveals a card at random from their hand. {this} deals damage to that creature and that player equal to the revealed card's mana value";
    }

    private FriendlyFireEffect(FriendlyFireEffect effect) {
        super((OneShotEffect)effect);
    }

    public FriendlyFireEffect copy() {
        return new FriendlyFireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controllerOfTargetCreature;
        Permanent targetCreature;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null && (targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null && (controllerOfTargetCreature = game.getPlayer(targetCreature.getControllerId())) != null && !controllerOfTargetCreature.getHand().isEmpty() && (card = controllerOfTargetCreature.getHand().getRandom(game)) != null) {
            CardsImpl cards = new CardsImpl(card);
            controllerOfTargetCreature.revealCards(sourceObject.getName(), (Cards)cards, game);
            int damage = card.getManaValue();
            targetCreature.damage(damage, source.getSourceId(), source, game, false, true);
            controllerOfTargetCreature.damage(damage, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

