/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FroghemothEffect
extends OneShotEffect {
    FroghemothEffect() {
        super(Outcome.Exile);
        this.staticText = "exile up to that many target cards from their graveyard. Put a +1/+1 counter on {this} for each creature card exiled this way. You gain 1 life for each noncreature card exiled this way";
    }

    private FroghemothEffect(FroghemothEffect effect) {
        super((OneShotEffect)effect);
    }

    public FroghemothEffect copy() {
        return new FroghemothEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashSet<Card> cardsToExile = new HashSet<Card>();
        int numCounters = 0;
        int lifeGain = 0;
        for (UUID cardId : this.getTargetPointer().getTargets(game, source)) {
            Card card = game.getCard(cardId);
            if (card == null || game.getState().getZone(cardId) != Zone.GRAVEYARD || !cardsToExile.add(card)) continue;
            if (card.isCreature(game)) {
                ++numCounters;
                continue;
            }
            ++lifeGain;
        }
        if (!cardsToExile.isEmpty()) {
            Permanent permanent;
            controller.moveCards(cardsToExile, Zone.EXILED, source, game);
            game.processAction();
            if (numCounters > 0 && (permanent = source.getSourcePermanentIfItStillExists(game)) != null) {
                permanent.addCounters(CounterType.P1P1.createInstance(numCounters), source.getControllerId(), source, game);
            }
            if (lifeGain > 0) {
                controller.gainLife(lifeGain, game, source);
            }
        }
        return true;
    }
}

