/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.AkroanSoldierToken;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.RandomUtil;
import mage.util.functions.StackObjectCopyApplier;

class FrontlineHeroismEffect
extends OneShotEffect {
    FrontlineHeroismEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 red Soldier creature token with haste, then copy that spell. The copy targets that token";
    }

    private FrontlineHeroismEffect(FrontlineHeroismEffect effect) {
        super((OneShotEffect)effect);
    }

    public FrontlineHeroismEffect copy() {
        return new FrontlineHeroismEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        if (player == null || spell == null) {
            return false;
        }
        AkroanSoldierToken token = new AkroanSoldierToken();
        token.putOntoBattlefield(1, game, source);
        Set permanents = token.getLastAddedTokenIds().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        switch (permanents.size()) {
            case 0: {
                return false;
            }
            case 1: {
                permanent = (Permanent)RandomUtil.randomFromCollection(permanents);
                break;
            }
            default: {
                FilterPermanent filter = new FilterPermanent("token to target with the copied spell");
                filter.add((Predicate)new PermanentReferenceInCollectionPredicate(permanents, game));
                TargetPermanent target = new TargetPermanent(filter);
                target.withNotTarget(true);
                player.choose(this.outcome, (Target)target, source, game);
                permanent = game.getPermanent(target.getFirstTarget());
            }
        }
        spell.createCopyOnStack(game, source, source.getControllerId(), false, 1, (StackObjectCopyApplier)new FrontlineHeroismApplier(permanent, game));
        return true;
    }

    private static final class FrontlineHeroismApplier
    implements StackObjectCopyApplier {
        private final Iterator<MageObjectReferencePredicate> predicate;

        FrontlineHeroismApplier(Permanent permanent, Game game) {
            this.predicate = Arrays.asList(new MageObjectReferencePredicate((MageObject)permanent, game)).iterator();
        }

        public void modifySpell(StackObject stackObject, Game game) {
        }

        public MageObjectReferencePredicate getNextNewTargetType() {
            if (this.predicate.hasNext()) {
                return this.predicate.next();
            }
            return null;
        }
    }
}

