/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.RegenerateTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FullMoonsRiseEffect
extends OneShotEffect {
    private final FilterPermanent filter;

    public FullMoonsRiseEffect(FilterPermanent filter) {
        super(Outcome.Regenerate);
        this.filter = filter;
        this.staticText = "Regenerate all Werewolf creatures you control";
    }

    private FullMoonsRiseEffect(FullMoonsRiseEffect effect) {
        super((OneShotEffect)effect);
        this.filter = effect.filter.copy();
    }

    public FullMoonsRiseEffect copy() {
        return new FullMoonsRiseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(this.filter, source.getControllerId(), game)) {
            RegenerateTargetEffect effect = new RegenerateTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

