/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.UntapAllEffect;
import mage.constants.Duration;
import mage.constants.TurnPhase;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.AttackedThisTurnPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.turn.Turn;

class FullThrottleTriggeredAbility
extends DelayedTriggeredAbility {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures that attacked this turn");

    public FullThrottleTriggeredAbility() {
        super((Effect)new UntapAllEffect((FilterPermanent)filter), Duration.EndOfTurn, false);
        this.setTriggerPhrase("At the beginning of each combat this turn, ");
    }

    private FullThrottleTriggeredAbility(FullThrottleTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public FullThrottleTriggeredAbility copy() {
        return new FullThrottleTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COMBAT_PHASE_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Turn turn = game.getState().getTurn();
        return turn.getPhase().getType() == TurnPhase.COMBAT;
    }

    static {
        filter.add((Predicate)AttackedThisTurnPredicate.instance);
    }
}

