/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.common.ZoneChangeTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FuneralMarchTriggeredAbility
extends ZoneChangeTriggeredAbility {
    public FuneralMarchTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, (Effect)new SacrificeEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, 1, "its controller"), "When enchanted creature leaves the battlefield, ", false);
    }

    private FuneralMarchTriggeredAbility(FuneralMarchTriggeredAbility ability) {
        super((ZoneChangeTriggeredAbility)ability);
    }

    public FuneralMarchTriggeredAbility copy() {
        return new FuneralMarchTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = game.getPermanentOrLKIBattlefield(this.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null && event.getTargetId().equals(enchantment.getAttachedTo()) && event.getType() == GameEvent.EventType.ZONE_CHANGE) {
            ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
            if (!(this.fromZone != null && zEvent.getFromZone() != this.fromZone || this.toZone != null && zEvent.getToZone() != this.toZone)) {
                for (Effect effect : this.getEffects()) {
                    Permanent attachedTo;
                    if (zEvent.getTarget() == null || (attachedTo = (Permanent)game.getLastKnownInformation(enchantment.getAttachedTo(), Zone.BATTLEFIELD, enchantment.getAttachedToZoneChangeCounter())) == null) continue;
                    effect.setTargetPointer((TargetPointer)new FixedTarget(attachedTo.getControllerId()));
                }
                return true;
            }
        }
        return false;
    }
}

