/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class FurnaceOfRathEffect
extends ReplacementEffectImpl {
    FurnaceOfRathEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a source would deal damage to a permanent or player, it deals double that damage to that permanent or player instead";
    }

    private FurnaceOfRathEffect(FurnaceOfRathEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FurnaceOfRathEffect copy() {
        return new FurnaceOfRathEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: 
            case DAMAGE_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

