/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FuryCharmRemoveCounterEffect
extends OneShotEffect {
    FuryCharmRemoveCounterEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove two time counters from target permanent or suspended card";
    }

    private FuryCharmRemoveCounterEffect(FuryCharmRemoveCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public FuryCharmRemoveCounterEffect copy() {
        return new FuryCharmRemoveCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            permanent.removeCounters(CounterType.TIME.getName(), 2, source, game);
            return true;
        }
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card != null) {
            card.removeCounters(CounterType.TIME.getName(), 2, source, game);
            return true;
        }
        return false;
    }
}

