/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RevelInSilenceEffect
extends ContinuousRuleModifyingEffectImpl {
    RevelInSilenceEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "Your opponents can't cast spells or activate planeswalkers' loyalty abilities this turn.";
    }

    private RevelInSilenceEffect(RevelInSilenceEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public RevelInSilenceEffect copy() {
        return new RevelInSilenceEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        Player activePlayer = game.getPlayer(game.getActivePlayerId());
        MageObject mageObject = game.getObject(source);
        if (activePlayer == null || mageObject == null) {
            return null;
        }
        return "You can't cast spells or activate planeswalkers' loyalty abilities this turn (" + mageObject.getLogName() + ')';
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL || event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            return false;
        }
        switch (event.getType()) {
            case CAST_SPELL: {
                return true;
            }
            case ACTIVATE_ABILITY: {
                Ability ability = game.getAbility(event.getTargetId(), event.getSourceId()).orElse(null);
                if (!(ability instanceof LoyaltyAbility)) {
                    return false;
                }
                Permanent permanent = game.getPermanent(event.getSourceId());
                return permanent != null && permanent.isPlaneswalker(game);
            }
        }
        return false;
    }
}

