/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.UseAttachedCost;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TapAttachmentCost
extends UseAttachedCost {
    public TapAttachmentCost() {
    }

    protected TapAttachmentCost(TapAttachmentCost cost) {
        super((UseAttachedCost)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (this.mageObjectReference == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return this.paid;
        }
        for (UUID attachmentId : permanent.getAttachments()) {
            if (!this.mageObjectReference.refersTo(attachmentId, game)) continue;
            Permanent attachment = game.getPermanent(attachmentId);
            boolean bl = this.paid = attachment != null && attachment.isControlledBy(controllerId) && attachment.tap(source, game);
            if (!this.paid) continue;
            break;
        }
        return this.paid;
    }

    public TapAttachmentCost copy() {
        return new TapAttachmentCost(this);
    }

    public String getText() {
        return "tap " + this.name;
    }
}

