/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.costs.common.CyclingDiscardCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.keyword.CyclingAbility;
import mage.cards.g.GaviNestWardenWatcher;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CyclingZeroCostEffect
extends CostModificationEffectImpl {
    CyclingZeroCostEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.SET_COST);
        this.staticText = "You may pay {0} rather than pay the cycling cost of the first card you cycle each turn.";
    }

    private CyclingZeroCostEffect(CyclingZeroCostEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (game.inCheckPlayableState() || player.chooseUse(this.outcome, "Pay {0} to cycle this card?", source, game)) {
            abilityToModify.clearManaCostsToPay();
            abilityToModify.getCosts().removeIf(cost -> !CyclingDiscardCost.class.isInstance(cost));
            abilityToModify.addManaCostsToPay((ManaCost)new GenericManaCost(0));
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        GaviNestWardenWatcher watcher = (GaviNestWardenWatcher)game.getState().getWatcher(GaviNestWardenWatcher.class);
        return abilityToModify instanceof CyclingAbility && watcher != null && watcher.cyclingActivationsThisTurn(abilityToModify.getControllerId()) == 0 && abilityToModify.getControllerId().equals(source.getControllerId());
    }

    public CyclingZeroCostEffect copy() {
        return new CyclingZeroCostEffect(this);
    }
}

